/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.Distance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;

public final class PickConeRay
extends PickCone {
    public PickConeRay() {
    }

    public PickConeRay(Point3d point3d, Vector3d vector3d, double d2) {
        this.origin = new Point3d(point3d);
        this.direction = new Vector3d(vector3d);
        this.spreadAngle = d2;
    }

    public void set(Point3d point3d, Vector3d vector3d, double d2) {
        this.origin.set(point3d);
        this.direction.set(vector3d);
        this.spreadAngle = d2;
    }

    final boolean intersect(Bounds bounds, Point4d point4d) {
        Point4d point4d2 = new Point4d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d = new Point3d();
        if (bounds instanceof BoundingSphere) {
            Point3d point3d2 = ((BoundingSphere)bounds).getCenter();
            double d2 = ((BoundingSphere)bounds).getRadius();
            double d3 = Distance.pointToRay(point3d2, this.origin, this.direction, point3d, null);
            vector3d.sub(point3d, this.origin);
            double d4 = vector3d.length();
            double d5 = this.getRadius(d4);
            return d3 <= (d2 + d5) * (d2 + d5);
        }
        if (bounds instanceof BoundingBox) {
            Point3d point3d3 = new Point3d();
            ((BoundingBox)bounds).getLower(point3d3);
            Point3d point3d4 = ((BoundingBox)bounds).getCenter();
            double d6 = Distance.pointToRay(point3d4, this.origin, this.direction, point3d, null);
            vector3d.sub(point3d, this.origin);
            double d7 = vector3d.length();
            double d8 = this.getRadius(d7);
            double d9 = point3d4.x - point3d3.x + d8;
            double d10 = d9 * d9;
            d9 = point3d4.y - point3d3.y + d8;
            d10 += d9 * d9;
            d9 = point3d4.z - point3d3.z + d8;
            d10 += d9 * d9;
            if (d6 > d10) {
                return false;
            }
            if (d6 < d8 * d8) {
                return true;
            }
            if (((BoundingBox)bounds).intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            Point3d point3d5 = new Point3d();
            ((BoundingBox)bounds).getUpper(point3d5);
            Point3d[][] point3dArrayArray = new Point3d[][]{{point3d5, new Point3d(point3d3.x, point3d5.y, point3d5.z)}, {new Point3d(point3d3.x, point3d5.y, point3d5.z), new Point3d(point3d3.x, point3d3.y, point3d5.z)}, {new Point3d(point3d3.x, point3d3.y, point3d5.z), new Point3d(point3d5.x, point3d3.y, point3d5.z)}, {new Point3d(point3d5.x, point3d3.y, point3d5.z), point3d5}, {point3d3, new Point3d(point3d3.x, point3d5.y, point3d3.z)}, {new Point3d(point3d3.x, point3d5.y, point3d3.z), new Point3d(point3d5.x, point3d5.y, point3d3.z)}, {new Point3d(point3d5.x, point3d5.y, point3d3.z), new Point3d(point3d5.x, point3d3.y, point3d3.z)}, {new Point3d(point3d5.x, point3d3.y, point3d3.z), point3d3}, {point3d3, new Point3d(point3d3.x, point3d3.y, point3d5.z)}, {new Point3d(point3d3.x, point3d5.y, point3d3.z), new Point3d(point3d3.x, point3d5.y, point3d5.z)}, {new Point3d(point3d5.x, point3d5.y, point3d3.z), new Point3d(point3d5.x, point3d5.y, point3d5.z)}, {new Point3d(point3d5.x, point3d3.y, point3d3.z), new Point3d(point3d5.x, point3d3.y, point3d5.z)}};
            for (int i2 = 0; i2 < point3dArrayArray.length; ++i2) {
                double d11 = Distance.rayToSegment(this.origin, this.direction, point3dArrayArray[i2][0], point3dArrayArray[i2][1], point3d, null, null);
                vector3d.sub(point3d, this.origin);
                d7 = vector3d.length();
                d8 = this.getRadius(d7);
                if (!(d11 <= d8 * d8)) continue;
                return true;
            }
            return false;
        }
        if (bounds instanceof BoundingPolytope) {
            Point3d point3d6 = new Point3d();
            BoundingSphere boundingSphere = new BoundingSphere(bounds);
            boundingSphere.getCenter(point3d6);
            double d12 = boundingSphere.getRadius();
            double d13 = Distance.pointToRay(point3d6, this.origin, this.direction, point3d, null);
            vector3d.sub(point3d, this.origin);
            double d14 = vector3d.length();
            double d15 = this.getRadius(d14);
            if (d13 > (d12 + d15) * (d12 + d15)) {
                return false;
            }
            if (bounds.intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            Point3d point3d7 = new Point3d();
            for (int i3 = 0; i3 < boundingPolytope.nVerts; ++i3) {
                int n2 = i3;
                while (i3 < boundingPolytope.nVerts) {
                    point3d7.x = (boundingPolytope.verts[i3].x + boundingPolytope.verts[n2].x) * 0.5;
                    point3d7.y = (boundingPolytope.verts[i3].y + boundingPolytope.verts[n2].y) * 0.5;
                    point3d7.z = (boundingPolytope.verts[i3].z + boundingPolytope.verts[n2].z) * 0.5;
                    if (PickCylinder.pointInPolytope(boundingPolytope, point3d7.x, point3d7.y, point3d7.z)) {
                        double d16 = Distance.rayToSegment(this.origin, this.direction, boundingPolytope.verts[i3], boundingPolytope.verts[n2], point3d, null, null);
                        vector3d.sub(point3d, this.origin);
                        d14 = vector3d.length();
                        d15 = this.getRadius(d14);
                        if (d16 <= d15 * d15) {
                            return true;
                        }
                    }
                    ++i3;
                }
            }
            return false;
        }
        return false;
    }

    PickShape transform(Transform3D transform3D) {
        Point3d point3d = new Point3d();
        PickConeRay pickConeRay = new PickConeRay();
        pickConeRay.origin.x = this.origin.x;
        pickConeRay.origin.y = this.origin.y;
        pickConeRay.origin.z = this.origin.z;
        pickConeRay.spreadAngle = this.spreadAngle;
        point3d.x = this.origin.x + this.direction.x;
        point3d.y = this.origin.y + this.direction.y;
        point3d.z = this.origin.z + this.direction.z;
        transform3D.transform(pickConeRay.origin);
        transform3D.transform(point3d);
        pickConeRay.direction.x = point3d.x - pickConeRay.origin.x;
        pickConeRay.direction.y = point3d.y - pickConeRay.origin.y;
        pickConeRay.direction.z = point3d.z - pickConeRay.origin.z;
        pickConeRay.direction.normalize();
        return pickConeRay;
    }
}

